/**
 * 
 * @authors Your Name (you@example.org)
 * @date    2019-05-28 00:23:08
 * @version $Id$
 */

//====== Vue Z Utils

// Функция для добавления свойства из Vuex store в 2-way computed свойство объекта.
const vuex_model=(path, name, mutation)=>{
	// Функция для добавления свойства из Vuex store в 2-way computed свойство объекта.
	//   name - имя свойста,
	//   mutation - имя mutation для изменения.
	//   path - префикс, через '/' - имена NameSpaced компонент
	/*
	{
	get () {
		return this.$store.state.obj.message
	},
	set (value) {
		this.$store.commit('updateMessage', value)
	}
	}
	*/
	var lst=[], mut = path + "/" + mutation;

	if(typeof(path)!=="undefined"&&path!=null&&path!=""){
		lst = path.split("/");
	};
	lst.push(name);

	return {
	get () {
		return lst.reduce((prev, cur)=>prev[cur], this.$store.state)
	},
	set (value) {
		this.$store.commit(mut, value)
	}
	}
}

// Полифил. Определяет функцию объединения массивов в Object.Assign или JQuery $.extend
const assign = (function() {
	var ass;
	ass = Object.Assign;
	if(typeof(ass)!=="undefined"&&ass!=null){
		return ass;
	};
	ass = $.extend; 
	if(typeof(ass)!=="undefined"&&ass!=null){
		return ass;
	};
	return function() {
		console.error("Function Object.Assign or $.extend not found. Use JQuery.")
	}
})();

// Автоматически генерирует словарь мутаций Vuex для указанного списка полей.
// добавляет мутации вида "set_" + имя поля 
const make_mutation = function (fields, prefix) {
	if(typeof(prefix)=="undefined") prefix="set";
	var res = {};
	for(let i=0, l=fields.length; i<l; i++) {
		res[prefix+"_"+fields[i]] = function(state, data) {
			state[fields[i]]=data;
		}
	}
	return res
};

function openFileFromPostUrl(url, post_data, csrf, method) {
	/* 
		оправляет словарь значений post на url через форму, используя метод POST.
		Используется для получения и открытия файла с сервера, который генерируется на 
		основании переданных в POST данных (Напремер, Excel).

		В ответе сервера нужно установить 'Content-Disposition' = 'attachment; filename="my_file_name.xxx"'
		И правильный 'content-type',
		Тогда браузер сразу предложит сохранить полученный файл.

		var csrf=$( "input[name='csrfmiddlewaretoken']" ).eq(0);
		!! Этот вариант использует JQuery
	*/

	if (method === null || method === undefined || method=== "") method = "post";
	var form = $('<form/>', {
		action: url,
		method: method,
		target: '_blank',
		style: {
			display: 'none'
		}
	});

	//form.append($(csrf));
	//<input type="hidden" name="csrfmiddlewaretoken" value="KexnNtGu2HuR58FZVnO0Cm9zvmlXRGcz">
	form.append($('<input/>', {
		type: 'hidden',
		name: "csrfmiddlewaretoken",
		value: csrf
		}
	));

	for (key in post_data) {
			form.append($('<input/>', {
				type: 'hidden',
				name: key,
				value: post_data[key]
				}
			));
		};
	//document.querySelector('body')
	form.appendTo($("body"))
	form.submit();
	form.remove();
};

// using jQuery
function getCookie(name) {
    var cookieValue = null;
    if (document.cookie && document.cookie !== '') {
        var cookies = document.cookie.split(';');
        for (var i = 0; i < cookies.length; i++) {
            var cookie = jQuery.trim(cookies[i]);
            // Does this cookie string begin with the name we want?
            if (cookie.substring(0, name.length + 1) === (name + '=')) {
                cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                break;
            }
        }
    }
    return cookieValue;
};

function JQAjaxSetup() {
	// Инициализирует JQuery Ajax для работы с POST и csrf
	// Использует Cookies

		window.csrftoken = Cookies.get('csrftoken');

		function csrfSafeMethod(method) {
				// these HTTP methods do not require CSRF protection
				return (/^(GET|HEAD|OPTIONS|TRACE)$/.test(method));
		}
		$.ajaxSetup({
				beforeSend: function(xhr, settings) {
						if (!csrfSafeMethod(settings.type) && !this.crossDomain) {
								xhr.setRequestHeader("X-CSRFToken", window.csrftoken);
						}
				}
		});
};


function openFileFromPost_axios() {
	// Загрузка файла из запроса к серверу без создания промежуточной формы.
	// !!Не работает. Это как пример
	axios({
		url: 'http://api.dev/file-download', //your url
		method: 'GET',
		responseType: 'blob', // important
	}).then((response) => {
		const url = window.URL.createObjectURL(new Blob([response.data]));
		const link = document.createElement('a');
		link.href = url;
		link.setAttribute('download', 'file.pdf'); //or any other extension
		document.body.appendChild(link);
		link.click();
	});
};


function openFileFromPost_jq(url, params, method, csrf) {
	// Загрузка файла из запроса к серверу без создания промежуточной формы.
	// Использует JQuery ajax. Возвращает Promise
	// method по умолчанию 'get', csrf - не обязателен

	//!! Не работает

	if (method === null || method === undefined || method=== "") method = "get";

	return new Promise((resolve, reject)=>{
		$.ajax({ 
			url:url, 
			type:method, 
			dataType:'text', 
			data:params,
			success (data){
				console.log(data)
				let lnk = $('a');
				let link_url = window.URL.createObjectURL(new Blob([data], {type : 'text/csv'}));
				console.log(link_url)
				lnk.href=link_url;
				lnk.download = 'hello.csv';
				//$("body").append(lnk);
				//lnk.click();
				//lnk.remove();
				URL.revokeObjectURL(link_url);
				resolve()
			},
			error (jqXHR, textStatus, errorThrown) {
				reject(errorThrown)
			}
		});
	})
}

//========