/**
 * 
 * @authors Your Name (you@example.org)
 * @date    2017-06-28 10:32:12
 * @version $Id$
 */

sur_servertime = function (getservertime_url_l) {
    //Объект работы с временем сервера и расхождениями.
    return {
        getservertime_url: getservertime_url_l,
        delta:null, //Разница, в секундах, server_time = local_time+delta  
        tz:0,

        asksrv: function () {
            //Получает время от сервера, определяет и запоминает разницу
            var self = this;
            self.delta = 0;
            $.getJSON( 
                this.getservertime_url,
                function (data) {
                    //{curtime:, tz:,}
                    console.log("Srv:"+JSON.stringify(data));
                    self.delta = data.curtime - (new Date()).getTime()/1000 + 1;
                    self.tz = data.tz;
                }
            )
            .fail(function( jqxhr, textStatus, error ) {
                self.delta = 0;
                self.tz = 0;
            });
        },

        to_srv: function(local_time) {
            //local_time: если Number - то секунды с начала эпохи, Object - Data,
            //Возвращает объект Data по времени сервера 
            //Если local_time не указан или null - берется текущее время.
            if (this.delta === null) {
                this.asksrv();
            }
            if (typeof local_time === "number") {
                return new Date((local_time + this.delta) * 1000)
            } 
            if (typeof local_time === "object" && local_time instanceof Date) {
            } else {
                local_time = new Date();
            }
            return new Date(local_time.getTime() + this.delta * 1000)
        },

        to_local: function(srv_time) {
            //srv_rime: если Number - то секунды с начала эпохи, Object - Data,
            //Возвращает объект Data по локальному времени 
            //Если srv_time не указан или null - берется текущее время.
            if (this.delta === null) {
                this.asksrv();
            }
            if (typeof srv_time === "number") {
                return new Date((srv_time - this.delta) * 1000)
            } 
            if (typeof srv_time === "object" && srv_time instanceof Date) {
            } else {
                srv_time = new Date();
            }
            return new Date(srv_time.getTime() - this.delta * 1000)
        }
    }
};

sur_get_servertime = function (getservertime_url) {
    //Deferred Объект работы с временем сервера и расхождениями.

    var res = $.Deferred();
    var servertime_obj={
        getservertime_url: getservertime_url,
        delta:0, //Разница, в секундах, server_time = local_time+delta  
        tz:0,

        to_srv: function(local_time) {
            //local_time: если Number - то секунды с начала эпохи, Object - Data,
            //Возвращает объект Data по времени сервера 
            //Если local_time не указан или null - берется текущее время.
            if (typeof local_time === "number") {
                return new Date((local_time + this.delta) * 1000)
            } 
            if (typeof local_time === "object" && local_time instanceof Date) {
            } else {
                local_time = new Date();
            }
            return new Date(local_time.getTime() + this.delta * 1000)
        },

        to_local: function(srv_time) {
            //srv_rime: если Number - то секунды с начала эпохи, Object - Data,
            //Возвращает объект Data по локальному времени 
            //Если srv_time не указан или null - берется текущее время.
            if (typeof srv_time === "number") {
                return new Date((srv_time - this.delta) * 1000)
            } 
            if (typeof srv_time === "object" && srv_time instanceof Date) {
            } else {
                srv_time = new Date();
            }
            return new Date(srv_time.getTime() - this.delta * 1000)
        }
    };

    $.getJSON( 
        getservertime_url,
        function (data) {
            //{curtime:, tz:,}
            console.log("def Srv:"+JSON.stringify(data));
            servertime_obj.delta = data.curtime - (new Date()).getTime()/1000 + 0,3;
            servertime_obj.tz = data.tz;
            res.resolve(servertime_obj);
        }
    )
    .fail(function( jqxhr, textStatus, error ) {
        servertime_obj.delta = 0;
        servertime_obj.tz = 0;
        res.resolve(servertime_obj);
    });

    return res;

};
