/**
	Утилиты

	Переписано под axios
**/

function z_load_ajax_ax(ajax_params, done_func, err_func, finall_func, params) {
	// Возвращает Promise, внутри которого вызывается AJAX через axios
	// с параметрами ajax_params. Проверяется answer==success
	// вызываются либо done_func (если все успешно), либо err_func.
	// если done_func вернула что-то, то вместо resolve() вызывается err_func с этим "что-то" и reject
	// в reject передается результат err_func
	// params.no_answer - не проверять anwser
	// err_func(mode, err_text, err)
	// done_func(data)
	// finall_func()
	// можно задать каллбеки внутри ajax_params, params.no_answer как no_check_answer
	// в ajax_params можно задать init_func, которая вызывается до ajax. init_func(resolve, reject)
	// возвращает null - продолжать работу,
	// {resolve: <data>} или {reject:<data>} - соответственно вызвать resolve или reject промиса
	// с указаными агруменами в качестве значения. Если возвращает не null, но значения undefined - 
	// resolve / reject не вызывается, просто прекращается промис. То есть уже были вызваны.


	console.log('ajpar',ajax_params)
	var init_func=null;
	var chk_callback = (cbk) => {
		if (typeof cbk==="undefined") return null;
		return cbk
	}

	ajax_params.dataType = "json";
	if (typeof params === "undefined" || params===null) {
		params={}
	}

	done_func = chk_callback(done_func)
	if (typeof ajax_params.done_func !== "undefined") {
		done_func = ajax_params.done_func
	}

	err_func = chk_callback(err_func)
	if (typeof ajax_params.err_func !== "undefined") {
		err_func = ajax_params.err_func
	}

	finall_func = chk_callback(finall_func)
	if (typeof ajax_params.finall_func !== "undefined") {
		finall_func = ajax_params.finall_func
	}

	if (typeof ajax_params.init_func !== "undefined") {
		init_func = ajax_params.init_func
	}

	if (typeof ajax_params.no_check_answer !== "undefined") {
		params.no_answer = ajax_params.no_check_answer
	}

	return new Promise((resolve, reject) => {
		if (init_func !== null) {
			let res_init = init_func(resolve, reject);
			if (typeof res_init !=="undefined" && res_init !== null) {
				let res = res_init.resolve;
				if (typeof res !== "undefined") {
					if (finall_func !== null) finall_func();
					resolve(res);
					return;
				}
				res = res_init.reject;
				if (typeof res !== "undefined") {
					if (finall_func !== null) finall_func();
					console.log("init function reject");
					reject(res);
					return;
				}
				return;
			}
		};

		if (ajax_params.method=='GET'){
			ajax_params.params=ajax_params.data;
		}
		var csrftoken = Cookies.get('csrftoken')
		if (!ajax_params.headers){
			ajax_params.headers={}
		}
		ajax_params.headers['X-Requested-With']='XMLHttpRequest';
		ajax_params.headers['X-CSRFToken']=csrftoken;
		ajax_params.withCredentials=true;

		var ajax_par = ajax_params
		var fdata=new FormData()
		for (var i in ajax_params.data){
			fdata.append(i,ajax_params.data[i])
		}
		ajax_par.data = fdata
		
		axios(ajax_par).then((data1)=>{
			var data = data1.data
			console.log(data)
			console.log('dat')
			console.log(data1)
			if (params.no_answer || data.answer != "error") {
				console.log('succ', done_func)
				let res = done_func(data);
				console.log('succ1')
				if (typeof res === "undefined" || res == null) {
					console.log('final')
					if (finall_func !== null) finall_func();
					resolve(data);
					return
				} else {
					console.log('error')
					let eres = null;
					if (err_func !== null) {
						eres = err_func('user', res, res)
					} else {
						eres = res
					};
					if (finall_func !== null) finall_func();
					reject(eres);
					return
				}
			} else {
				let eres = null;
				if (err_func !== null) {
					eres = err_func('data', data.error, data)
				} else {
					eres = data.error
				};
				if (finall_func !== null) finall_func();
				reject(eres);
				return
			}
		}).catch((err) => {
			let eres = null;
			if (err_func !== null) {
				eres = err_func('server', err.statusText, err)
			} else {
				eres = err.statusText
			};
			if (finall_func !== null) finall_func();
			reject(eres);
			return
		});
	})
};
